package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.EncourageMaterialDto;

import java.util.List;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: RemoteEncourageMaterialService
 * Function: 激励广告相关 素材远程服务
 * Date:     2019/5/30 0030 下午 3:20
 */
@AdvancedFeignClient
public interface RemoteEncourageMaterialService {

    List<EncourageMaterialDto> getEncourageMaterialByAdveertId(Long advertId);

    Integer updateEncourageMaterial(EncourageMaterialDto req);

    /**
     * 根据广告集合和默认状态批量查询弹层
     * @param advertIds
     * @param isDefault
     * @return
     */
    List<EncourageMaterialDto> getEncourageMaterialByList(List<Long> advertIds, Integer isDefault);

    /**
     * 根据弹层id获取数据
     * @param windIds
     * @return
     */
    List<EncourageMaterialDto> getEncourageMaterialByWinId(List<Long> windIds);

    /**
     * 根据条件查询数据
     * @param materialDto
     * @return
     */
    List<EncourageMaterialDto> getEncourageMaterialByMaterial(EncourageMaterialDto materialDto);

    /**
     * 根据id获取数据
     * @param id
     * @return
     */
    EncourageMaterialDto getEncourageMaterialById(Long id);

    /**
     * 更新素材激活/屏蔽状态.
     *
     * @param id            the id
     * @param status        the status
     * @return
     */
    Boolean updateEncourageActiveStatus(Long id, Integer status);

    /**
     * 查询有效的素材
     * @param advertId
     * @return
     */
    List<EncourageMaterialDto> findValidEncourageMaterialByAdvertId(Long advertId);

}
