package cn.com.duiba.tuia.core.api.remoteservice.orientPkg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.OrientPkgPeoplePkgRelationDto;
import cn.com.duiba.tuia.core.api.dto.UserTfFilterDto;
import cn.com.duiba.tuia.core.api.enums.OrientPeoplePkgSourceEnum;

import java.util.List;

/**
 * 
 * Function: 定向配置定向人群关系表. <br/>
 *
 * @author xuxx
 * @version 
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteOrientPkgPeoplePkgRelationService {

    /**
     * 根据配置id查询
     * @param orientId
     * @return
     */
    List<OrientPkgPeoplePkgRelationDto> obtainRelationByOrientPkgId(Long orientId);

    /**
     * 根据人群包id 和 来源查询
     * @return
     */
    List<OrientPkgPeoplePkgRelationDto> obtainRelationByPeoplePkgIdAndSource(String peoplePkgId, OrientPeoplePkgSourceEnum Source);

    /**
     * 提交选中的定向人群包
     * @return
     */
    Integer submitPickedPeoplePkg(Long orientId ,List<OrientPkgPeoplePkgRelationDto> orientPkgPeoplePkgRelationDtos);


    /**
     * 批量 提交选中的定向人群包
     * @return
     */
    Integer submitPickedPeoplePkgs(List<Long> orientIds ,List<OrientPkgPeoplePkgRelationDto> orientPkgPeoplePkgRelationDtos);


    /**
     * 批量 提交已转化人群过滤
     */
    Integer submitUserTfFilters(List<Long> orientIds ,String type,List<String> target);

    /**
     * 根据配置id 查询 已转化过滤人群
     * @param orientIds
     * @return
     */
    UserTfFilterDto obtainUserTfFilterByOrientId(Long orientIds);

}

