package cn.com.duiba.tuia.core.api.dto.systemConfig;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName: AdvertRepeatLunchConfigDto <br/>
 * Function: 特殊场景重复发券限制. <br/>
 * date: 2019年1月15日 下午6:59:20 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class AdvertRepeatLunchConfigDto extends BaseDto {

    private static final long serialVersionUID = 5612981199271389078L;

    /** 资源id */
    private String            sourceId;

    /** 类型 @ResourceRepeatLunchTypeEnum */
    private Integer           sourceType;

    /** 资源名称 */
    private String            sourceName;

    /** 发券间隔 */
    private Integer           lunchInterval;

    /** 发券上限 */
    private Integer           maxLimit;

    /**
     * sourceType.
     *
     * @return the sourceType
     * @since JDK 1.8
     */
    public Integer getSourceType() {
        return sourceType;
    }

    /**
     * sourceType.
     *
     * @param sourceType the sourceType to set
     * @since JDK 1.8
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * sourceId.
     *
     * @return the sourceId
     * @since JDK 1.8
     */
    public String getSourceId() {
        return sourceId;
    }

    /**
     * sourceId.
     *
     * @param sourceId the sourceId to set
     * @since JDK 1.8
     */
    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    /**
     * sourceName.
     *
     * @return the sourceName
     * @since JDK 1.8
     */
    public String getSourceName() {
        return sourceName;
    }

    /**
     * sourceName.
     *
     * @param sourceName the sourceName to set
     * @since JDK 1.8
     */
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * lunchInterval.
     *
     * @return the lunchInterval
     * @since JDK 1.8
     */
    public Integer getLunchInterval() {
        return lunchInterval;
    }

    /**
     * lunchInterval.
     *
     * @param lunchInterval the lunchInterval to set
     * @since JDK 1.8
     */
    public void setLunchInterval(Integer lunchInterval) {
        this.lunchInterval = lunchInterval;
    }

    /**
     * maxLimit.
     *
     * @return the maxLimit
     * @since JDK 1.8
     */
    public Integer getMaxLimit() {
        return maxLimit;
    }

    /**
     * maxLimit.
     *
     * @param maxLimit the maxLimit to set
     * @since JDK 1.8
     */
    public void setMaxLimit(Integer maxLimit) {
        this.maxLimit = maxLimit;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
