package cn.com.duiba.tuia.core.api.enums;

/**
 * Created by huangch on 2019/4/3 09:47
 * description:
 *
 * @since JDK 1.6
 */
public enum TargetRecommendEnum {

    NEW_APP_TEST(1, "新媒体测试", "新媒体测试验证行业于该媒体的CVR>行业平均CVR"),

    NEW_ADVERT_SUPPORT(2, "新广告扶持", "新广告扶持推荐理由待定"),

    APP_ADVERT_HT(3, "媒体广告互通", "媒体广告互通推荐理由待定");

    private Integer type;

    private String desc;

    private String reason;

    TargetRecommendEnum(Integer type, String desc, String reason) {
        this.type = type;
        this.desc = desc;
        this.reason = reason;
    }

    public static String getRecommendReason(Integer recommendType) {
        if (recommendType == null) {
            return "";
        }
        for (TargetRecommendEnum recommendEnum : values()) {
            if (recommendEnum.getType().equals(recommendType)) {
                return recommendEnum.getReason();
            }
        }

        return "";
    }

    public static String getRecommendDesc(Integer recommendType) {
        if (recommendType == null) {
            return "";
        }
        for (TargetRecommendEnum recommendEnum : values()) {
            if (recommendEnum.getType().equals(recommendType)) {
                return recommendEnum.getDesc();
            }
        }

        return "";
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}
