package cn.com.duiba.tuia.core.api.dto.rsp.account;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.List;

/**
 * ClassName:QualificationRsp <br/>
 * Function: 资质资源信息. <br/>
 * Date: 2017年11月27日 上午10:54:08 <br/>
 *
 * @author chencheng
 * @see
 * @since JDK 1.8
 */
public class QualificationResourceDto extends BaseDto {

    private static final long serialVersionUID = -3219399191779427812L;

    /**
     * 行业资源名称.
     */
    private String qualificationName;

    /**
     * 父ID，既行业id.
     */
    private Long parentId;

    /**
     * 行业名称
     */
    private String parentName;

    /**
     * 资质资源
     */
    List<QualificationResourceDto> children;

    /**
     * 状态:0-启用，1-停用
     */
    private Integer status;

    /**
     * qualificationName.
     *
     * @return the qualificationName
     * @since JDK 1.8
     */
    public String getQualificationName() {
        return qualificationName;
    }

    /**
     * qualificationName.
     *
     * @param qualificationName the qualificationName to set
     * @since JDK 1.8
     */
    public void setQualificationName(String qualificationName) {
        this.qualificationName = qualificationName;
    }

    /**
     * parentId.
     *
     * @return the parentId
     * @since JDK 1.8
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parentId.
     *
     * @param parentId the parentId to set
     * @since JDK 1.8
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    /**
     * children.
     *
     * @return the children
     * @since JDK 1.8
     */
    public List<QualificationResourceDto> getChildren() {
        return children;
    }

    /**
     * children.
     *
     * @param children the children to set
     * @since JDK 1.8
     */
    public void setChildren(List<QualificationResourceDto> children) {
        this.children = children;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public QualificationResourceDto() {
        super();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
