package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AppBaseDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertApplyAppAuditDto;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertApplyAppQueryRsp;
import cn.com.duiba.tuia.core.api.dto.advert.AppApplyAdvertAppInfoDto;
import cn.com.duiba.tuia.core.api.dto.advert.AppApplyAdvertRspDto;
import cn.com.duiba.tuia.core.api.dto.advert.ReqAuditAdvertApplyAppDto;
import cn.com.duiba.tuia.core.api.dto.advert.ReqAuditAppApplyAdvertDto;
import cn.com.duiba.tuia.core.api.dto.advert.req.IdMappingIdsDto;
import cn.com.duiba.tuia.core.api.dto.app.AdBaseInfoDto;

import java.util.List;

/**
 * Created by huangch on 2018/4/10 13:45
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertAppWhiteApplyService {

    /**
     * 计数广告申请媒体申请列表
     *
     * @param advertIds   查询的广告id
     * @param applyStatus 申请状态
     * @return num
     */
    Integer countAdvertApplyApp(List<Long> advertIds, Integer applyStatus);

    /**
     * 查询广告申请媒体申请列表
     *
     * @param advertIds   查询的广告id
     * @param applyStatus 申请状态
     * @return 申请列表
     */
    List<AdvertApplyAppQueryRsp> pageQueryAdvertApplyApp(List<Long> advertIds, Integer applyStatus, Integer start, Integer limit);

    /**
     * 广告申请媒体提交
     *
     * @param advertList 申请的广告信息
     * @param appList    申请的媒体信息
     * @return true or false
     */
    Boolean commitAdvertApplyApp(List<IdMappingIdsDto> advertList, List<IdMappingIdsDto> appList);

    /**
     * 媒体申请广告提交
     *
     * @param advertIds 申请的广告
     * @param appList   申请的媒体
     * @return true or false
     */
    Boolean commitAppApplyAdvert(List<Long> advertIds, List<AppApplyAdvertAppInfoDto> appList);

    /**
     * 查询广告申请媒体的媒体信息列表
     *
     * @param applyId 申请ID
     * @return 媒体信息
     */
    List<AppBaseDto> queryAdvertApplyAppAppInfoByApplyId(Long applyId);

    /**
     * 查询媒体申请广告的广告信息列表
     *
     * @param applyId 申请ID
     * @return 广告及其配置信息
     */
    List<AdBaseInfoDto> queryAppApplyAdvertAdInfoByApplyId(Long applyId);

    /**
     * 广告申请媒体查询待审核列表
     *
     * @param applyId 申请id
     * @return 待审核列表
     */
    AdvertApplyAppAuditDto queryAuditApplyList(Long applyId);

    /**
     * 分页查询媒体申请广告申请列表
     *
     * @param appIds      查询的媒体id
     * @param applyStatus 申请状态
     * @return 媒体申请广告申请列表
     */
    List<AppApplyAdvertRspDto> pageQueryAppApplyAdvert(List<Long> appIds, List<Long> permissionAdvertIds, Integer applyStatus, Integer start, Integer limit);

    /**
     * 计数媒体申请广告申请列表
     *
     * @param appIds      查询的媒体id
     * @param applyStatus 申请状态
     * @return 数量
     */
    Integer countAppApplyAdvert(List<Long> appIds, List<Long> permissionAdvertIds, Integer applyStatus);

    /**
     * 广告申请媒体审核操作
     */
    Boolean auditAdvertApplyApp(ReqAuditAdvertApplyAppDto req);

    /**
     * 媒体申请广告审核操作
     */
    Boolean auditAppApplyAdvert(ReqAuditAppApplyAdvertDto req);

    /**
     * 添加媒体到定向包
     */
    Boolean addAppToTargeApp(List<Long> orientPackageIds,Long appId);

}
