package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.boot.netflix.feign.hystrix.FeignHystrixProperty;
import cn.com.duiba.boot.netflix.feign.hystrix.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.core.api.dto.app.AdvertDataDto;

import java.util.List;

/**
 * Created by huangch on 2017/8/29 17:25
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAppWhiteListService {

    /**
     * 流量策略获取广告列表
     * @param slotId
     * @param appId
     * @param strategyId
     * @param advertId
     * @param type
     * @return
     */
    @FeignHystrixProperty(name= HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value="20000")
    List<AdvertDataDto> getAdvertList(Long slotId, Long appId, Long strategyId, String advertId, String type);
}
