package cn.com.duiba.tuia.core.api.remoteservice.compensate;

import java.util.List;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.compensate.CompensateAdvertDTO;
import cn.com.duiba.tuia.core.api.dto.compensate.CompensatePackageDTO;
import cn.com.duiba.tuia.core.api.param.CompensatePagingParam;

/**
 * 赔付服务
 *
 * @author peanut.huang
 * @date 2019/10/14
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteCompensateBackendService {

    /**
     * 赔付列表分页查询
     *
     * @param pagingParam
     * @return
     */
    PageDto<CompensateAdvertDTO> pagingList(CompensatePagingParam pagingParam);


    /**
     * 查询赔付配置列表
     *
     * @param advertId 赔付计划id
     * @param compensateDate  赔付日期
     * @return
     */
    List<CompensatePackageDTO> selectPackageList(Long advertId, String compensateDate);

    /**
     * 切换赔付开关
     *
     * @param compensateId  赔付记录id
     * @param targetSwitch  目标开关值
     * @return
     * @throws BizException
     */
    Boolean changSwitch(Long compensateId, Integer targetSwitch) throws BizException;

    /**
     * 查询计划配置内容
     *
     * @param advertId 计划id
     * @return 返回null时说明不要提醒
     */
    String getCompensateRemind(Long advertId);
}
