package cn.com.duiba.tuia.core.api.remoteservice.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaAlreadSlotBlackReq;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaAlreadSlotWhiteReq;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaCopySlotBlackReq;
import cn.com.duiba.tuia.core.api.dto.media.request.MediaCopySlotWhiteReq;
import cn.com.duiba.tuia.core.api.dto.media.response.*;

import java.util.List;

/**
 * @function 广告位黑名单
 */
@AdvancedFeignClient
public interface RemoteMediaAppBlackListService {

    /**
     * 提供广告位黑名单数量,福袋状态（应用管理）
     */
//    RspMediaSlotWhiteDto getSlotBlackCountAndLuckBagStatus(Long slotId);


    /**
     * 提供复制黑名单接口，参数 原广告位 solt1，目标广告位 solt2，sot3，。。。总共不超过10个。
     * （如果广告位同时在广告主，又在广告位黑名单中，复制时候只需要复制广告主就可以了）
     */
    Boolean copyMediaSlotBlack(MediaCopySlotWhiteReq mediaCopySlotWhiteReq);


    /**
     * 批量将广告加入到广告位对应的黑名单中
     */
    Boolean batchAddAdvertToBlackList(Long slotId, List<Long> advertIds);


    /**
     * 批量将广告主加入到广告主广告位黑名单中
     */
    Boolean batchAddAccountToBlackList(Long slotId, List<Long> accountIds);

    /**
     * 单个将广告从广告位黑名单中移除
     */
    Boolean removeAdvertFromBlackList(Long slotId, Long advertId);


    /**
     * 单个将广告主从广告主黑名单中移除
     */
    Boolean removeAccountFromBlackList(Long slotId, Long accountId);


    /**
     * 查询广告已添加到广告位黑名单下的广告计划(需要分页) List<RspMediaSlotAdvertBlackDto>
     */
    PageDto<RspMediaSlotAdvertWhiteDto> getAlreadAdvertSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);



    /**
     * 查询广告主已添加到广告位黑名单下的广告主（需要分页）List<RspMediaSlotAccountBlackDto>
     */
    PageDto<RspMediaSlotAccountWhiteDto> getAlreadAccountSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);


    /**
     * 根据广告id/广告名称/广告主id/广告主名称   查询广告信息（需要分页） List<RspMediaSlotAdvertBlackDto>
     */

    PageDto<RspMediaSlotAdvertWhiteDto> getAdvertSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);


    /**
     * 根据广告主id/广告主名称 查询广告主信息（需要分页）List<RspMediaSlotAccountBlackDto
     */
    PageDto<RspMediaSlotAccountWhiteDto> getAccountSlotBlackList(
            MediaAlreadSlotWhiteReq mediaAlreadSlotWhiteReq);

}
