package cn.com.duiba.tuia.core.api.dto.land;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author Wangpf
 * @description 页面诊断结果
 * @date 2019/7/22 16:23
 */
public class LandPageDiagnosisDto extends BaseDto {

    /**
     * 页面ID
     */
    private long pageId;

    /**
     * 总的加载时间
     */
    private BigDecimal loadTime;

    /**
     * 白屏时间
     */
    private BigDecimal whiteScreenTime;

    /**
     * 加载类型
     */
    private int  loadType;

    /**
     * 当前页面大小
     */
    private BigDecimal pageSize;


    public LandPageDiagnosisDto() {
    }

    public LandPageDiagnosisDto(long pageId, BigDecimal loadTime, BigDecimal whiteScreenTime, int loadType, BigDecimal pageSize) {
        this.pageId = pageId;
        this.loadTime = loadTime;
        this.whiteScreenTime = whiteScreenTime;
        this.loadType = loadType;
        this.pageSize = pageSize;
    }

    public long getPageId() {
        return pageId;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public BigDecimal getLoadTime() {
        return loadTime;
    }

    public void setLoadTime(BigDecimal loadTime) {
        this.loadTime = loadTime;
    }

    public BigDecimal getWhiteScreenTime() {
        return whiteScreenTime;
    }

    public void setWhiteScreenTime(BigDecimal whiteScreenTime) {
        this.whiteScreenTime = whiteScreenTime;
    }

    public int getLoadType() {
        return loadType;
    }

    public void setLoadType(int loadType) {
        this.loadType = loadType;
    }

    public BigDecimal getPageSize() {
        return pageSize;
    }

    public void setPageSize(BigDecimal pageSize) {
        this.pageSize = pageSize;
    }
}
