package cn.com.duiba.tuia.core.api.dto.req.agent;

import cn.com.duiba.tuia.core.api.statistics.domain.BaseQueryReq;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author Wangpf
 * @description  代理商日志查询参数
 * @date 2019/10/8 10:11 AM
 */
@ApiModel(value = "代理商日志查询参数")
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class AgentOperationLogReq extends BaseQueryReq {

    @ApiModelProperty(value = "代理商名称或代理商Id",required = true)
    private String pattern;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "开始时间，yyyy-MM-dd",required = true)
    private String startDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "结束时间，yyyy-MM-dd",required = true)
    private String endDate;

}
