package cn.com.duiba.tuia.core.api.enums;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * 新媒体流量策略配置位运算开关 date: 2017年4月17日 下午2:17:12 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AppFlowStrategyValidPeriodHourEnum {
    Hour_1("0000",1),
    Hour_2("0030",2),
    Hour_3("0100",3),
    Hour_4("0130",4),
    Hour_5("0200",5),
    Hour_6("0230",6),
    Hour_7("0300",7),
    Hour_8("0330",8),
    Hour_9("0400",9),
    Hour_10("0430",10),
    Hour_11("0500",11),
    Hour_12("0530",12),
    Hour_13("0600",13),
    Hour_14("0630",14),
    Hour_15("0700",15),
    Hour_16("0730",16),
    Hour_17("0800",17),
    Hour_18("0830",18),
    Hour_19("0900",19),
    Hour_20("0930",20),
    Hour_21("1000",21),
    Hour_22("1030",22),
    Hour_23("1100",23),
    Hour_24("1130",24),
    Hour_25("1200",25),
    Hour_26("1230",26),
    Hour_27("1300",27),
    Hour_28("1330",28),
    Hour_29("1400",29),
    Hour_30("1430",30),
    Hour_31("1500",31),
    Hour_32("1530",32),
    Hour_33("1600",33),
    Hour_34("1630",34),
    Hour_35("1700",35),
    Hour_36("1730",36),
    Hour_37("1800",37),
    Hour_38("1830",38),
    Hour_39("1900",39),
    Hour_40("1930",40),
    Hour_41("2000",41),
    Hour_42("2030",42),
    Hour_43("2100",43),
    Hour_44("2130",44),
    Hour_45("2200",45),
    Hour_46("2230",46),
    Hour_47("2300",47),
    Hour_48("2330",48),
    Hour_49("2400",49);

    /** 代码 */
    private String code;
    /** 描述 */
    private int    desc;
    
    private List<String> list;

    private AppFlowStrategyValidPeriodHourEnum(String code, int desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AppFlowStrategyValidPeriodHourEnum getByCode(String code) {
        for (AppFlowStrategyValidPeriodHourEnum enumVal : AppFlowStrategyValidPeriodHourEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }
    
    public static String getByDesc(int desc) {
        for (AppFlowStrategyValidPeriodHourEnum enumVal : AppFlowStrategyValidPeriodHourEnum.values()) {
            if (desc == enumVal.getDesc()) {
                return enumVal.getCode();
            }
        }
        return null;
    }

    public static List<String> getAll(){
        List<String> list = new ArrayList<String>();
        for (AppFlowStrategyValidPeriodHourEnum enumVal : AppFlowStrategyValidPeriodHourEnum.values()) {
            list.add(enumVal.getCode());
        }
        return list;
    }
    /**
     * code.
     *
     * @return the code
     */
    public String getCode() {
        return code;
    }



    /**
     * desc.
     *
     * @return the desc
     */
    public int getDesc() {
        return desc;
    }


    
    /**
     * list.
     *
     * @return  the list
     */
    public List<String> getList() {
        if (list == null) {
            this.list = getAll();
        }
        return list;
    }

}
