package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertSpecialBannerDto;

import java.util.List;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: RemoteAdvertSpecialBannerService
 * Function: 特殊广告处理映射关系 远程servie
 * Date:     2019/3/19 0019 下午 16:57
 */
@AdvancedFeignClient
public interface RemoteAdvertSpecialBannerService {

    /**
     * 根据 广告id 广告名称 广告主名称 查询已经配置的 特殊广告处理映射关系 未删除的
     * @param advertIds
     * @return
     */
    List<AdvertSpecialBannerDto> advertBannerList(List<Long> advertIds);


    /**
     * 根据广告id 删除特殊广告处理映射关系
     * @param advertId
     * @return
     */
    Boolean deleteAdvertBanner(Long advertId);

    /**
     * 新增或者修改 特殊广告映射关系
     * @param dto
     * @return
     */
    Boolean updateOrAddAdvertBanner(AdvertSpecialBannerDto dto);

    /**
     * 修改特殊广告 开启状态
     * @param advertId
     * @param enable
     * @return
     */
    Boolean updateStatus(Long advertId, Integer enable);
}
