/**
 * 
 */
package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 此类描述的是： 分页查询条件.
 *
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
@ApiModel("分页查询参数")
public class BaseQueryReq implements Serializable{

    /** 最大导出1w条. */
    public static final int MAX_EXPORT_SIZE=10000;

    /** 每页20条数据. */
    public static final int PAGE_SIZE_20 = 20;

    /** 每页10条数据. */
    public static final int PAGE_SIZE_10 = 10;
    private static final long serialVersionUID = 3928122506866213671L;

    //sso登录的账户ID
    private Long ssoAccountId;

    /** 起始记录数. */
    @ApiModelProperty(value="起始记录数，默认：0",hidden = true)
    private Integer         rowStart     = 0;

    /** 当前页. */
    @ApiModelProperty(value="当前页，默认：1",required = true)
    private Integer         currentPage  = 1;

    /** 每页记录数，默认为50， 为-1时代表查询所有. */
    @ApiModelProperty(value="每页记录数，默认为50， 为-1时代表查询所有",required = true)
    private Integer         pageSize     = 50;

    /** 排序字段. */
    @ApiModelProperty("排序字段")
    private String          sort;

    /** 排序方式：(升序:asc,降序：desc)默认降序. */
    @ApiModelProperty("排序方式:升序:asc,降序：默认，desc")
    private String          order        = "desc";

    public void forExport() {
        setCurrentPage(1);
        setPageSize(MAX_EXPORT_SIZE-1);
    }

    public Long getSsoAccountId() {
        return ssoAccountId;
    }

    public void setSsoAccountId(Long ssoAccountId) {
        this.ssoAccountId = ssoAccountId;
    }

    /**
     * Gets the row start.
     *
     * @return the rowStart
     */
    public Integer getRowStart() {
        return rowStart;
    }

    /**
     * Sets the row start.
     *
     * @param rowStart the rowStart to set
     */
    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    /**
     * Gets the current page.
     *
     * @return the currentPage
     */
    public Integer getCurrentPage() {
        return currentPage;
    }

    /**
     * Sets the current page.
     *
     * @param currentPage the currentPage to set
     */
    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    /**
     * Gets the page size.
     *
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * Sets the page size.
     *
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * Gets the sort.
     *
     * @return the sort
     */
    public String getSort() {
        return sort;
    }

    /**
     * Sets the sort.
     *
     * @param sort the sort to set
     */
    public void setSort(String sort) {
        this.sort = sort;
    }

    /**
     * Gets the order.
     *
     * @return the order
     */
    public String getOrder() {
        return order;
    }

    /**
     * Sets the order.
     *
     * @param order the order to set
     */
    public void setOrder(String order) {
        this.order = order;
    }

    /**
     * 
     * initRowStart:(起始记录数计算). <br/>
     *
     * @author chencheng
     * @since JDK 1.8
     */
    public void initRowStart() {
        this.setRowStart((this.getCurrentPage() - 1) * this.getPageSize());
    }
    
    
    /**
     * @see Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseQueryReq [rowStart=");
        builder.append(rowStart);
        builder.append(", currentPage=");
        builder.append(currentPage);
        builder.append(", pageSize=");
        builder.append(pageSize);
        builder.append(", sort=");
        builder.append(sort);
        builder.append(", order=");
        builder.append(order);
        builder.append("]");
        return builder.toString();
    }

}
