package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.FusingRecordDto;

import java.util.List;

/**
 * Created by huangch on 2019/1/29 11:30
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteFusingRecordService {

    /**
     * 查询广告人工熔断的列表
     *
     * @param advertId 广告ID
     * @return
     */
    List<FusingRecordDto> selectManualListByAdvertId(Long advertId);

    /**
     * 插入人工熔断的配置
     *
     * @param advertId      广告ID
     * @param orientationId 配置ID，默认配置传0
     * @return
     */
    Integer insertManualFusingPackage(Long advertId, Long orientationId);
}
