package cn.com.duiba.tuia.core.api.dto.advert;

import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by ZhangShun at 2020/5/8
 */
@Getter
@Setter
public class AdvertSupportPlanDto implements Serializable {

    public static final Integer STATE_ENABLE = 1; // 扶持中
    public static final Integer STATE_SUSPEND = 2; // 已暂停
    public static final Integer STATE_FINISHED = 3; // 已结束

    /**
     * ID
     */
    private Long id;

    /**
     * 广告主ID，对应account.id
     */
    private Long accountId;

    private String accountName;

    /**
     * 广告ID，对应advert.id
     */
    private Long advertId;

    private String advertName;


    /**
     * 广告主类型，1=KA广告主、2=重点行业广告主、3=普通新广告主、4=潜力广告主
     */
    private Integer advertiserType;

    /**
     * 扶持状态，1=扶持中、2=已暂停、3=已结束
     */
    private Integer planState;

    /**
     * 扶持开始时间
     */
    private Date dateStart;

    /**
     * 扶持结束时间
     */
    private Date dateEnd;

    /**
     * 扶持结束时间端
     */
    private List<AdvertSupportPlanHourPeriodDto> hourPeriod;

    /**
     * 扶持结束时间端
     */
    private String hourPeriodStr;

    /**
     * 每日单广告上限，-1不限
     */
    private Long upperDayAdvert;

    /**
     * 每日单媒体上限，-1不限
     */
    private Long upperDayMedia;

    /**
     * 出价扶持低值
     */
    private Double priceStart;

    /**
     * 出价扶持高值
     */
    private Double priceEnd;

    /**
     * 扶持目标类型，1=落地页转化、2=启动、3=注册
     */
    private Integer targetType;

    /**
     * 扶持目标成本, 单位:分
     */
    private Integer targetCost;

    /**
     * 最后操作人
     */
    private String operation;

    /**
     * 最后操作时间
     */
    private Date modLastTime;

}
