package cn.com.duiba.tuia.core.api.dto.req.orientPkg;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

public class OrientPkgExpandReq implements Serializable {

    private static final long serialVersionUID = -1813452888135668590L;

    /** 广告id. */
    private Long       advertId;

    /** 广告id集合. */
    private List<Long> advertIds;

    /** 配置id集合. */
    private Long       orientId;

    /** 配置id. */
    private List<Long> orientIds;

    /** 应急广告填充类型，0-正常配置，1-系统填充 */
    private Integer urgentType;

    public Integer getUrgentType() {
        return urgentType;
    }

    public void setUrgentType(Integer urgentType) {
        this.urgentType = urgentType;
    }
    
    /**
     * advertId.
     *
     * @return  the advertId
     * @since   JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    
    /**
     * advertId.
     *
     * @param   advertId    the advertId to set
     * @since   JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    
    /**
     * advertIds.
     *
     * @return  the advertIds
     * @since   JDK 1.8
     */
    public List<Long> getAdvertIds() {
        return advertIds;
    }

    
    /**
     * advertIds.
     *
     * @param   advertIds    the advertIds to set
     * @since   JDK 1.8
     */
    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    
    /**
     * orientId.
     *
     * @return  the orientId
     * @since   JDK 1.8
     */
    public Long getOrientId() {
        return orientId;
    }

    
    /**
     * orientId.
     *
     * @param   orientId    the orientId to set
     * @since   JDK 1.8
     */
    public void setOrientId(Long orientId) {
        this.orientId = orientId;
    }

    
    /**
     * orientIds.
     *
     * @return  the orientIds
     * @since   JDK 1.8
     */
    public List<Long> getOrientIds() {
        return orientIds;
    }

    
    /**
     * orientIds.
     *
     * @param   orientIds    the orientIds to set
     * @since   JDK 1.8
     */
    public void setOrientIds(List<Long> orientIds) {
        this.orientIds = orientIds;
    }

    public OrientPkgExpandReq(List<Long> advertIds, Integer urgentType) {
        this.advertIds = advertIds;
        this.urgentType = urgentType;
    }

    public OrientPkgExpandReq() {
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
}
