package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.PhoneLibraryDto;

import java.util.List;

/**
 * @author: panaihua
 * @date: 2017年02月22日 15:08
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemotePhoneLibraryService {

    /**
     * 分页获取手机信息
     * @param phoneType
     * @param priceStatus
     * @return
     */
    PageDto<PhoneLibraryDto> getPhoneByConditions(Integer currentPage, Integer pageSize, String phoneType, Integer priceStatus);

    PageDto<PhoneLibraryDto> getPhoneByConditionNew(Integer currentPage, Integer pageSize, String phoneType, Integer priceStatus, String brandName);


    /**
     * 批量更新手机信息
     * @param phoneLibraryDtoList
     * @return
     */
    int updatePhoneLevel(List<PhoneLibraryDto> phoneLibraryDtoList);

    /**
     * 查询所有的设备信息
     * @return
     */
    List<PhoneLibraryDto> selectAll();

    /**
     * 批量新增设备信息
     * @param phoneLibraryDtoList
     * @return
     */
    int insertPhoneInfo(List<PhoneLibraryDto> phoneLibraryDtoList);

    /**
     * 根据条件查询
     * @param phoneLibraryDto
     * @return
     */
    List<PhoneLibraryDto> selectByPhoneLibraryDto(PhoneLibraryDto phoneLibraryDto);
}
