package cn.com.duiba.tuia.core.api.dto.rsp.advert;

import java.io.Serializable;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: DimensionalityIndexValueDto
 * Function: 广告各个维度指标数据 用于判断深度优化目标开启条件
 * Date:     2019/4/24 0024 上午 10:53
 */
public class AdvertDimensionalityIndexValueDto implements Serializable {


    private static final long serialVersionUID = -9021571140036010139L;

    /**
     *  签收7天内转化量
     */
    private Long signForDay7;

    /**
     * 付费3天内转化量
     */
    private Long payDay3;

    /**
     * 完件7天内转化量
     */
    private Long finishDay7;

    /**
     * 留存3天内转化量
     */
    private Long denyPvDay3;

    /**
     * 出单前6天至前3天的转化
     */
    private Long outOrderDay3;


    public AdvertDimensionalityIndexValueDto() {
    }

    public AdvertDimensionalityIndexValueDto(Long signForDay7, Long payDay3, Long finishDay7, Long denyPvDay3, Long outOrderDay3) {
        this.signForDay7 = signForDay7;
        this.payDay3 = payDay3;
        this.finishDay7 = finishDay7;
        this.denyPvDay3 = denyPvDay3;
        this.outOrderDay3 = outOrderDay3;
    }

    public Long getOutOrderDay3() {
        return outOrderDay3;
    }

    public void setOutOrderDay3(Long outOrderDay3) {
        this.outOrderDay3 = outOrderDay3;
    }

    public Long getSignForDay7() {
        return signForDay7;
    }

    public void setSignForDay7(Long signForDay7) {
        this.signForDay7 = signForDay7;
    }

    public Long getPayDay3() {
        return payDay3;
    }

    public void setPayDay3(Long payDay3) {
        this.payDay3 = payDay3;
    }

    public Long getFinishDay7() {
        return finishDay7;
    }

    public void setFinishDay7(Long finishDay7) {
        this.finishDay7 = finishDay7;
    }

    public Long getDenyPvDay3() {
        return denyPvDay3;
    }

    public void setDenyPvDay3(Long denyPvDay3) {
        this.denyPvDay3 = denyPvDay3;
    }
}
