/**
 * Project Name:tuia-advert-center-api
 * File Name:TagUserCountDto.java
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp.tagUserCount
 * Date:2018年3月21日下午5:39:00
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.dto.rsp.tagUserCount;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:TagUserCountDto <br/>
 * Function: 标签对应的用户接受度人群. <br/>
 * Date:     2018年3月21日 下午5:39:00 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public class TagUserCountDto implements Serializable{

    private static final long serialVersionUID = 1602512156343448919L;

    /** 时间 */
    private Date              curDate;

    /** 标签编号 */
    private String            tagNum;

    /** 打标:1对点击感兴趣,2对转化感兴趣,3对点击不感兴趣,4对转化不感兴趣,0未命中 */
    private Integer           mark;

    /** 去重uv */
    private Long              uv;

    
    /**
     * curDate.
     *
     * @return  the curDate
     * @since   JDK 1.8
     */
    public Date getCurDate() {
        return curDate;
    }

    
    /**
     * curDate.
     *
     * @param   curDate    the curDate to set
     * @since   JDK 1.8
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    
    /**
     * tagNum.
     *
     * @return  the tagNum
     * @since   JDK 1.8
     */
    public String getTagNum() {
        return tagNum;
    }

    
    /**
     * tagNum.
     *
     * @param   tagNum    the tagNum to set
     * @since   JDK 1.8
     */
    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    
    /**
     * mark.
     *
     * @return  the mark
     * @since   JDK 1.8
     */
    public Integer getMark() {
        return mark;
    }

    
    /**
     * mark.
     *
     * @param   mark    the mark to set
     * @since   JDK 1.8
     */
    public void setMark(Integer mark) {
        this.mark = mark;
    }

    
    /**
     * uv.
     *
     * @return  the uv
     * @since   JDK 1.8
     */
    public Long getUv() {
        return uv;
    }

    
    /**
     * uv.
     *
     * @param   uv    the uv to set
     * @since   JDK 1.8
     */
    public void setUv(Long uv) {
        this.uv = uv;
    }


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
}

