package cn.com.duiba.tuia.core.api.param;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/6/26.
 */
public class MultipleDateParam implements Serializable {

    private static final long serialVersionUID = 2223601653500747280L;
    // 代理商ID
    private Long oldAgentId;
    private Date startDate;
    private Date endDate;

    public Long getOldAgentId() {
        return oldAgentId;
    }

    public void setOldAgentId(Long oldAgentId) {
        this.oldAgentId = oldAgentId;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MultipleDateParam param = (MultipleDateParam) o;

        if (oldAgentId != null ? !oldAgentId.equals(param.oldAgentId) : param.oldAgentId != null) return false;
        if (startDate != null ? !startDate.equals(param.startDate) : param.startDate != null) return false;
        return endDate != null ? endDate.equals(param.endDate) : param.endDate == null;
    }

    @Override
    public int hashCode() {
        int result = oldAgentId != null ? oldAgentId.hashCode() : 0;
        result = 31 * result + (startDate != null ? startDate.hashCode() : 0);
        result = 31 * result + (endDate != null ? endDate.hashCode() : 0);
        return result;
    }
}
