package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.AdvertiserSecretKeyDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.AdvertiserSecretKeyGroupDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.req.ReqAdvertiserSecretKeyGroupDto;

import java.util.List;

/**
 *
 * @Author chensong
 * @Create 2019-01-23
 */
@AdvancedFeignClient
public interface RemoteAdvertiserSecretKeyGroupService {

    /**
     * 分页查询
     * @param param
     * @return
     */
    PageDto<AdvertiserSecretKeyGroupDto> queryPage(ReqAdvertiserSecretKeyGroupDto param);

    /**
     * 查询全部
     * @return
     */
    List<AdvertiserSecretKeyGroupDto> selectAll();

    /**
     * 根据id查询
     * @param groupId
     * @return
     */
    AdvertiserSecretKeyGroupDto selectById(Long groupId);

    /**
     * 根据秘钥组id查询广告主秘钥列表
     * @param groupId
     * @return
     */
    List<AdvertiserSecretKeyDto> listSecretKeyByGroupId(Long groupId);

    /**
     * 插入数据
     * @param dto
     * @return
     */
    Long insert(AdvertiserSecretKeyGroupDto dto);

    /**
     * 更新数据
     * @param dto
     * @return
     */
    int update(AdvertiserSecretKeyGroupDto dto);





}
