package cn.com.duiba.tuia.core.api.dto.advert;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 广告关键词巡查结果表
 * @author zhangdi
 * @since 2020-09-14
 */
@Getter
@Setter
public class AdvertKeyWordPatrolResultDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("媒体ID")
    private Long appId;

    @ApiModelProperty("广告位ID")
    private Long slotId;

    @ApiModelProperty("广告ID")
    private Long advertId;

    @ApiModelProperty("广告类型 1互动广告 2展示广告 3激励广告")
    private Long advertType;

    @ApiModelProperty("巡查类型 1缩略图 2普通素材 3adx素材 4增值素材 5普通落地页 6测试落地页 7新媒体落地页 8配置落地页 9特殊广告落地页")
    private Long patrolType;

    @ApiModelProperty("命中关键词")
    private String keyWords;

    @ApiModelProperty("url地址")
    private String typeUrl;

    @ApiModelProperty("扩展内容")
    private String extContent;

    @ApiModelProperty("创建时间")
    private Date gmtCreate;

    @ApiModelProperty("更新时间")
    private Date gmtModified;

}