package cn.com.duiba.tuia.core.api.dto.advert;

import cn.com.duiba.tuia.core.api.dto.BaseDto;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author Wangpf
 * @description
 * @date 2019/8/30 3:19 PM
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class AdvertSdkDto extends BaseDto {

    private static final long serialVersionUID = -1296355125114379963L;

    public static final Integer CONFIG_TYPE_DEF = 0;
    public static final Integer CONFIG_TYPE_DL = 1;
    public static final Integer CONFIG_TYPE_JF = 2;


    /** 自动更新模式*/
    public static final Integer AUTO = 0;
    /** 人工更新模式*/
    public static final Integer PEOPLE = 1;

    /**
     * 广告id
     */
    private Long advertId;

    /**
     * 应用名
     */
    private String applicationName;

    /**
     * 包名
     */
    private String packageName;

    /**
     * 样式控制
     */
    private Integer styleControl;

    /**
     * 应用图标链接
     */
    private String appIconUri;

    /**
     * 头部标题
     */
    private String title;

    /**
     * 应用描述
     */
    private String applicationDesc;

    /**
     * 配置类型
     */
    private Integer configType;

    /**
     * 微信弹窗标题
     */
    private String windowTitle;

    /**
     * 微信弹窗描述
     */
    private String windowDesc;

    /**
     * 微信弹窗Toast文案
     */
    private String toastDesc;

    /**
     * 微信ID
     */
    private String wechatId;

    /**
     * 微信名称
     */
    private String wechatName;

    /**
     * 微信头像
     */
    private String wechatPic;

    /**
     * 微信号更新模式
     */
    private Integer updMode;

    /**
     * 推广目的 0 非应用下载 1 应用下载
     */
    private Integer expandTarget;
}
