package cn.com.duiba.tuia.core.api.dto.agentPlatfromMessages;

import cn.com.duiba.tuia.core.api.enums.AgentPaltfromMessageTypeEnum;
import cn.com.duiba.tuia.core.api.enums.MessageTypeEnum;
import cn.com.duiba.tuia.core.api.enums.PlatformEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @program: tuia-advert-center
 * @description: 代理商平台通知消息实体
 * @author: Micheal.Wang
 * @blog: <a href="http://www.micheal.top">MichealWang</a>
 * @create: 2020-03-09 15:00
 **/
@Data
public class AgentPaltfromMessageDto implements Serializable {

    private static final long serialVersionUID = -3505784676992768605L;

    private Long id;

    private String title;

    private String context;

    /**
     * {@link AgentPaltfromMessageTypeEnum}
     */

    private Integer messageLevel;

    private Integer isRead;

    /**
     * 平台来源:0 广告管理后台  1  风控后台
     * {@link PlatformEnum}
     */
    private Integer platform;

    private String time;

    /**
     * 消息类型（0-广告类 ；1-广告主账号类  2-代理商账号类；3-资质类）
     * {@link MessageTypeEnum}
     */
    private Integer type;

    private Long advertId;

    private Long accountId;

}
