package cn.com.duiba.tuia.core.api.dto.compensate;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * 广告配置赔付DTO
 *
 * @author peanut.huang
 * @date 2019/10/14
 * @since JDK 1.8
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ToString
public class CompensatePackageDTO extends BaseDto implements Serializable {

    private static final long serialVersionUID = -7051028912101179349L;

    /**
     * 计划id
     */
    private Long        advertId;

    /**
     * 配置id
     */
    private Long        pkgId;

    /**
     * 赔付量级
     */
    private Long        compensateLevel;

    /**
     * 赔付金额
     */
    private Long        compensateAmount;

    /**
     * 目标成本
     */
    private Long        targetCost;

    /**
     * 转化成本
     */
    private Long        transferCost;

    /**
     * 成本异常百分比：(转化成本-目标成本)/目标成本
     */
    private Integer     expRate;
}
