/**
 * Project Name:tuia-core-api<br>
 * File Name:CreateAdvertDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年8月19日下午4:57:54<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.req;

import cn.com.duiba.tuia.core.api.dto.AdvertPlanPeriodDto;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * ClassName: CreateAdvertDto <br/>
 * Function: 创建广告请求参数. <br/>
 * date: 2016年8月19日 下午4:57:54 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class ReqGetCreateAdvertDto implements Serializable {

    private static final long         serialVersionUID = 1L;

    /** 广告主ID. */
    private Long                      advertiserId;
    /** 名称. */
    private String                    name;

    /** 计费方式. */
    private Integer                   chargeType;

    //广告类型，1-互动广告、2-展示广告
    private Integer advertType;

    /** 广告出价. */
    private Long                      fee;

    /** 每日预算. */
    private Long                      budgetPerDay;

    /** 生效期. */
    private String                    startDate;

    /** 失效期. */
    private String                    endDate;

    /** 投放平台. */
    private List<String>              platform;

    /** 投放时段列表. */
    private List<AdvertPlanPeriodDto> periods;

    /** 投放Id列表. */
    private String                    regionIds;

    /** 推广网址. */
    private String                    promoteURL;

    /** 推广链接类型 1：落地页网址，2：落地页名称*/
    private Integer                  promoteType;

    /** 商品名称. */
    private String                    couponName;

    /** 商品说明. */
    private String                    couponRemark;

    /** 一句话描述. */
    private String                    description;

    /** 品牌图标. */
    private String                    thumbnailPng;

    /** 首页banner图. */
    private String                    bannerPng;

    /** 按钮文案. */
    private String                    buttonText;

    /** 领取次数限制. */
    private Integer                   limitReceive;

    /** 优惠码类型. */
    private Integer                   codeType;

    /** 广告标签列表.*/
    private List<String>              matchTagNums;
    /**
     * 推广计划id 默认 -1 表示 没有对应的推广计划
     */
    private Long advertPlanId = -1L;

    /** 推广目的. 0 非应用下载 1 应用下载 */
    private Integer                   expandTarget;

    /** 安装包名. */
    private String                   packageName;

    public Long getAdvertPlanId() {
        return advertPlanId;
    }

    public void setAdvertPlanId(Long advertPlanId) {
        this.advertPlanId = advertPlanId;
    }

    public Integer getPromoteType() {
        return promoteType;
    }

    public void setPromoteType(Integer promoteType) {
        this.promoteType = promoteType;
    }

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    /**
     * buttonText.
     *
     * @return the buttonText
     */
    public String getButtonText() {
        return buttonText;
    }

    /**
     * buttonText.
     *
     * @param buttonText the buttonText to set
     */
    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public List<String> getMatchTagNums() {
        return matchTagNums;
    }

    public void setMatchTagNums(List<String> matchTagNums) {
        this.matchTagNums = matchTagNums;
    }

    public Long getAdvertiserId() {
        return advertiserId;
    }

    public void setAdvertiserId(Long advertiserId) {
        this.advertiserId = advertiserId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getChargeType() {
        return chargeType;
    }

    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getBudgetPerDay() {
        return budgetPerDay;
    }

    public void setBudgetPerDay(Long budgetPerDay) {
        this.budgetPerDay = budgetPerDay;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public List<String> getPlatform() {
        return platform;
    }

    public void setPlatform(List<String> platform) {
        this.platform = platform;
    }

    public List<AdvertPlanPeriodDto> getPeriods() {
        return periods;
    }

    public void setPeriods(List<AdvertPlanPeriodDto> periods) {
        this.periods = periods;
    }

    public String getRegionIds() {
        return regionIds;
    }

    public void setRegionIds(String regionIds) {
        this.regionIds = regionIds;
    }

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getCouponRemark() {
        return couponRemark;
    }

    public void setCouponRemark(String couponRemark) {
        this.couponRemark = couponRemark;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public Integer getLimitReceive() {
        return limitReceive;
    }

    public void setLimitReceive(Integer limitReceive) {
        this.limitReceive = limitReceive;
    }

    public Integer getCodeType() {
        return codeType;
    }

    public void setCodeType(Integer codeType) {
        this.codeType = codeType;
    }

    public Integer getExpandTarget() {
        return expandTarget;
    }

    public void setExpandTarget(Integer expandTarget) {
        this.expandTarget = expandTarget;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
