package cn.com.duiba.tuia.core.api.enums.fincance;

/**
 * 财务操作人员类型
 */
public enum FinanceOperatorType {
                         ADVERTISER(0, "广告主"),

                         ADMIN(1, "管理后台"),

                         AGENT(2, "代理商"),

    ;

    private Integer type;
    private String  desc;

    FinanceOperatorType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getType() {
        return type;
    }

    public static String getDesc(Integer type) {
        for (FinanceOperatorType financeOperatorType : FinanceOperatorType.values()) {
            if (financeOperatorType.type.equals(type)) {
                return financeOperatorType.desc;
            }
        }
        throw new AccountTypeNonExistent();
    }

    private static class AccountTypeNonExistent extends RuntimeException {

        AccountTypeNonExistent() {
            super("不存在的账户类型");
        }
    }

}