package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.*;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAuditRecordsDataService {

    /**
     * 查询符合条件的账号审核记录总条数
     */
    Integer queryAccountAuditDataCount(AuditRecordsFilterItemsDto dto);
    /**
     * 查询符合条件的账号审核记录
     */
    List<AccountAuditDataDto> queryAccountAuditData(AuditRecordsFilterItemsDto dto);

    /**
     * 查询 账号审核 记录关联的一些扩展信息
     * @return
     */
    AccountCheckRecordDto queryAccountAuditExtData(Long accountId);




    /**
     * 查询符合条件的资质审核记录总条数
     */
    Integer queryQualificationsAuditDataCount(AuditRecordsFilterItemsDto dto);
    /**
     * 查询符合条件的资质审核记录
     */
    List<QualificationsAuditDataDto> queryQualificationsAuditData(AuditRecordsFilterItemsDto dto);
    /**
     * 查询扩展数据
     */
    QualificationsAuditDataDto queryQualificationsAuditExtData(Long accountId);
    /**
     * 批量插入 资质审核记录
     */
    Integer batchInsertQualificationsAuditData(List<QualificationsAuditDataDto> dtos);




    /**
     * 查询符合条件的落地页审核记录总条数
     */
    Integer queryLandAuditDataCount(AuditRecordsFilterItemsDto dto);

    /**
     * 查询符合条件的落地页审核记录
     */
    List<LandAuditDataDto> queryLandAuditData(AuditRecordsFilterItemsDto dto);
    /**
     * 根据广告id 查询扩展数据
     * @param advertId
     * @return
     */
    LandAuditDataDto queryLandAuditExtData(Long advertId);
    /**
     * 插入 测试落地页审核记录
     */
    Integer insertLandAuditData(LandAuditDataDto dto);



    /**
     * 查询符合条件的素材审核记录总条数
     */
    Integer queryMaterialAuditDataCount(AuditRecordsFilterItemsDto dto);
    /**
     * 查询符合条件的素材审核记录
     */
    List<MaterialAuditDataDto> queryMaterialAuditData(AuditRecordsFilterItemsDto dto);


    /**
     * 查询扩展数据
     */
    MaterialAuditDataDto queryMaterialAuditExtData(MaterialAuditDataDto materialCheckRecordDO);
}
