package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/30 10:34
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteOldAdvertRelationService {

    /**
     * 查询关联的老广告ID.
     *
     * @param newAdvertId 新广告ID
     * @return the long
     */
    DubboResult<Long> selectOldId(Long newAdvertId);

    /**
     * Insert.
     *
     * @param newAdvertId the new advert id
     * @param oldAdvertId the old advert id
     * @return the int
     */
    DubboResult<Integer> insert(Long newAdvertId, Long oldAdvertId);

    /**
     * Delete.
     *
     * @param newAdvertId the new advert id
     * @return the int
     */
    DubboResult<Integer> delete(Long newAdvertId);

    /**
     * Update.
     *
     * @param newAdvertId the new advert id
     * @param oldAdvertId the old advert id
     * @return the int
     */
    DubboResult<Integer> update(Long newAdvertId, Long oldAdvertId);
}
