package cn.com.duiba.tuia.core.api.remoteservice.jfsite;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfSiteDomainDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfSiteDomainFormDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfSiteDomainQueryDTO;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * [JF建站]站点域名 RemoteService
 * @author lijicong
 * @since 2020-07-24
 */
@AdvancedFeignClient
public interface RemoteJfSiteDomainService {

    /**
     * 根据ID查询
     * @param id
     * @return
     */
    JfSiteDomainDTO queryById(Long id);

    /**
     * 多条件查询
     * @param queryDTO
     * @return
     */
    List<JfSiteDomainDTO> queryList(JfSiteDomainQueryDTO queryDTO);

    /**
     * 根据广告主账户ID查询有效域名
     * @param accountId
     * @return
     */
    List<JfSiteDomainDTO> queryValidDomainList(@NotNull Long accountId);

    /**
     * 根据域名查询对应广告主的ID
     * @param domainName
     * @return
     */
    List<Long> queryAccountIdsByDomainName(@NotBlank String domainName);

    /**
     * 查询数量
     * @param queryDTO
     * @return
     */
    long queryCount(JfSiteDomainQueryDTO queryDTO);

    /**
     * 分页查询
     * @param queryDTO
     * @return
     */
    PageDto<JfSiteDomainDTO> queryPage(JfSiteDomainQueryDTO queryDTO);

    /**
     * 保存
     * @param formDTO
     * @return
     */
    boolean save(JfSiteDomainFormDTO formDTO);

    /**
     * 批量保存
     * @param formDTO formDTO.domainNameList多个域名
     * @return
     */
    boolean addDomainList(JfSiteDomainFormDTO formDTO) throws BizException;

    /**
     * 查询有效的平台域名
     */
    List<JfSiteDomainDTO> queryValidPlatformDomainList();
}