
package cn.com.duiba.tuia.core.api.remoteservice.qualification;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.rsp.account.QualificationPackageDto;

import java.util.List;

/**
 * Function: 资质包信息接口. <br/>
 * Date:     2019年8月2日 上午9:59:03 <br/>
 *
 * @see
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteQualificationPackageService {

    /**
     * 资质包信息新增
     *
     * @param query 资质包信息
     * @return
     * @author lijian
     * @since JDK 1.8
     */
    Integer insertQualificationPackage(QualificationPackageDto query);

    /**
     * 修改资质包信息
     *
     * @param query 资质包信息
     * @return
     * @author lijian
     * @since JDK 1.8
     */
    Integer updateQualificationPackage(QualificationPackageDto query);

    /**
     * 根据广告主id 获取资质包信息
     *
     * @param accountIds
     * @return
     */
    List<QualificationPackageDto> getQualificationPackageByAccountIds(List<Long> accountIds);

    /**
     * 根据广告主id，资质包名称 获取资质包信息
     *
     * @param packageName
     * @return
     */
    QualificationPackageDto getQualificationPackageByPackageName(Long accountId, String packageName);

    /**
     * 更新资质包状态
     *
     * @param packageIds
     * @param abnormal
     * @return
     */
    Integer updateQualificationStatus(List<Long> packageIds, Integer abnormal);

}

