/**
 * 文件名： AdvertCheckRecordDO.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月11日 下午1:37:27
 */
package cn.com.duiba.tuia.core.api.dto;

import java.util.Date;

/**
 * 广告审核记录表.
 *
 * @author: leiliang
 * @version:
 */
public class AdvertCheckRecordDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    /**
     * 审核通过.
     */
    public static final int CHECK_PASS = 1;

    /**
     * 审核拒绝.
     */
    public static final int CHECK_REFUSE = 2;

    /**
     * 广告ID.
     */
    private Long advertId;

    /**
     * 审核动作类型,1-审核通过;2-审核拒绝.
     */
    private Integer checkType;

    /**
     * 拒绝理由.
     */
    private String reason;

    /**
     * 广告顾问.
     */
    private String checker;

    /**
     * 广告顾问的联系方式.
     */
    private String checkerContact;

    /**
     * 审核人.
     */
    private String reviewer;
    /**
     * 落地页截图url.
     */
    private String imageUrl;
    /**
     * 图片P哈希值 用于比较图片差异
     */
    private String hashDegree;
    /**
     * 广告名称.
     */
    private String advertName;
    /**
     * 广告主ID.
     */
    private Long accountId;
    /**
     * 广告主名称.
     */
    private String companyName;
    /**
     * 代理商名称
     */
    private String agentCompanyName;

    /**
     * 上次广告审核的审核状态,1-审核通过;2-审核拒绝.，如果是审核通过则是老计划,只用于运营分析广告每日自动化审核比例
     */
    private Integer oldCheckType;

    /**
     * 是否复审:0 否 1 是
     */
    private Integer reviewed;

    /** 审核时长(s)*/
    private Long checkLoadTime;

    /** 进审时间. */
    private Date enterCheckTime;
    /** 差异值*/
    private Integer diff;

    /** 富文本*/
    private String context;

    /**
     * 拒绝理由
     */
    private String refuseReason;

    /**
     * 拒绝理由模板列表
     */
    private String refuseTemplateIds;

    //广告推广链接
    private String promoteUrl;
    /** 素材链接*/
    private String materialUrl;

    /**
     * Gets the advert id.
     *
     * @return the advertId
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advertId to set
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the check type.
     *
     * @return the checkType
     */
    public Integer getCheckType() {
        return checkType;
    }

    /**
     * Sets the check type.
     *
     * @param checkType the checkType to set
     */
    public void setCheckType(Integer checkType) {
        this.checkType = checkType;
    }

    /**
     * Gets the reason.
     *
     * @return the reason
     */
    public String getReason() {
        return reason;
    }

    /**
     * Sets the reason.
     *
     * @param reason the reason to set
     */
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * Gets the checker.
     *
     * @return the checker
     */
    public String getChecker() {
        return checker;
    }

    /**
     * Sets the checker.
     *
     * @param checker the checker to set
     */
    public void setChecker(String checker) {
        this.checker = checker;
    }

    /**
     * Gets the checker contact.
     *
     * @return the checkerContact
     */
    public String getCheckerContact() {
        return checkerContact;
    }

    /**
     * Sets the checker contact.
     *
     * @param checkerContact the checkerContact to set
     */
    public void setCheckerContact(String checkerContact) {
        this.checkerContact = checkerContact;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getHashDegree() {
        return hashDegree;
    }

    public void setHashDegree(String hashDegree) {
        this.hashDegree = hashDegree;
    }

    public String getAdvertName() {
        return advertName;
    }

    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAgentCompanyName() {
        return agentCompanyName;
    }

    public void setAgentCompanyName(String agentCompanyName) {
        this.agentCompanyName = agentCompanyName;
    }

    public Integer getOldCheckType() {
        return oldCheckType;
    }

    public void setOldCheckType(Integer oldCheckType) {
        this.oldCheckType = oldCheckType;
    }

    public Integer getReviewed() {
        return reviewed;
    }

    public void setReviewed(Integer reviewed) {
        this.reviewed = reviewed;
    }

    public Long getCheckLoadTime() {
        return checkLoadTime;
    }

    public void setCheckLoadTime(Long checkLoadTime) {
        this.checkLoadTime = checkLoadTime;
    }

    public Date getEnterCheckTime() {
        return enterCheckTime;
    }

    public void setEnterCheckTime(Date enterCheckTime) {
        this.enterCheckTime = enterCheckTime;
    }

    public Integer getDiff() {
        return diff;
    }

    public void setDiff(Integer diff) {
        this.diff = diff;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public String getRefuseTemplateIds() {
        return refuseTemplateIds;
    }

    public void setRefuseTemplateIds(String refuseTemplateIds) {
        this.refuseTemplateIds = refuseTemplateIds;
    }

    public String getPromoteUrl() {
        return promoteUrl;
    }

    public void setPromoteUrl(String promoteUrl) {
        this.promoteUrl = promoteUrl;
    }

    public String getMaterialUrl() {
        return materialUrl;
    }

    public void setMaterialUrl(String materialUrl) {
        this.materialUrl = materialUrl;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AdvertCheckRecordDto [advertId=");
        builder.append(advertId);
        builder.append(", checkType=");
        builder.append(checkType);
        builder.append(", reason=");
        builder.append(reason);
        builder.append(", checker=");
        builder.append(checker);
        builder.append(", checkerContact=");
        builder.append(checkerContact);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

}
