/**
 * Project Name:tuia-advert-center-api File Name:ReqAdvertDto.java Package
 * Name:cn.com.duiba.tuia.core.api.dto.req.advert Date:2017年9月28日下午3:59:16 Copyright (c) 2017, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.advert;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName:ReqAdvertDto <br/>
 * Function: 广告信息查询dto. <br/>
 * Date: 2017年9月28日 下午3:59:16 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
public class ReqAdvertDto extends BaseDto {

    private static final long serialVersionUID = 8966095790572282754L;

    /** 广告ID. */
    private Long              advertId;

    /** 广告ID集合. */
    private List<Long>        advertIds;

    /** 广告名称 */
    private String            advertName;

    /**
     * 广告主ID.
     */
    private Long              accountId;

    
    /** 广告主ID集合. */
    private List<Long> accountIds;
    
    /**
     * 启用状态,1-启用;0-暂停.
     */
    private Integer           enableStatus;

    /**
     * 审核状态,0-审核中;1-审核通过;2-审核拒绝.
     */
    private Integer           checkStatus;

    /**
     * 有效状态 @{AdvertValidStatusEnum}.
     */
    private Integer           validStatus;

    /**
     * 是否被删除 ,1-已删除;0-未删除.
     */
    private Integer           isDeleted;
    
    /**
     * 是否过期有效 ,1-已失效;0-未失效.
     */
    private Integer    abate;

    /**
     * 广告来源,0-广告平台,1-兑吧商品,2-券库.
     */
    private Integer           source;

    /**
     * 是否开启重复曝光：0 否 1是
     **/
    private Integer           repeatExposure;

    /**
     * 广告类型,1-互动广告、2-展示广告、3-激励广告
     **/
    private Integer           advertType;

    public Integer getAdvertType() {
        return advertType;
    }

    public void setAdvertType(Integer advertType) {
        this.advertType = advertType;
    }

    /**
     * abate.
     *
     * @return the abate
     * @since JDK 1.8
     */
    public Integer getAbate() {
        return abate;
    }

    /**
     * abate.
     *
     * @param abate the abate to set
     * @since JDK 1.8
     */
    public void setAbate(Integer abate) {
        this.abate = abate;
    }

    /**
     * accountIds.
     *
     * @return the accountIds
     * @since JDK 1.8
     */
    public List<Long> getAccountIds() {
        return accountIds;
    }

    /**
     * accountIds.
     *
     * @param accountIds the accountIds to set
     * @since JDK 1.8
     */
    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * advertIds.
     *
     * @return the advertIds
     * @since JDK 1.8
     */
    public List<Long> getAdvertIds() {
        return advertIds;
    }

    /**
     * advertIds.
     *
     * @param advertIds the advertIds to set
     * @since JDK 1.8
     */
    public void setAdvertIds(List<Long> advertIds) {
        this.advertIds = advertIds;
    }

    /**
     * advertName.
     *
     * @return the advertName
     * @since JDK 1.8
     */
    public String getAdvertName() {
        return advertName;
    }

    /**
     * advertName.
     *
     * @param advertName the advertName to set
     * @since JDK 1.8
     */
    public void setAdvertName(String advertName) {
        this.advertName = advertName;
    }

    /**
     * accountId.
     *
     * @return the accountId
     * @since JDK 1.8
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * accountId.
     *
     * @param accountId the accountId to set
     * @since JDK 1.8
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    /**
     * enableStatus.
     *
     * @return the enableStatus
     * @since JDK 1.8
     */
    public Integer getEnableStatus() {
        return enableStatus;
    }

    /**
     * enableStatus.
     *
     * @param enableStatus the enableStatus to set
     * @since JDK 1.8
     */
    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    /**
     * checkStatus.
     *
     * @return the checkStatus
     * @since JDK 1.8
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.8
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * validStatus.
     *
     * @return the validStatus
     * @since JDK 1.8
     */
    public Integer getValidStatus() {
        return validStatus;
    }

    /**
     * validStatus.
     *
     * @param validStatus the validStatus to set
     * @since JDK 1.8
     */
    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    /**
     * isDeleted.
     *
     * @return the isDeleted
     * @since JDK 1.8
     */
    public Integer getIsDeleted() {
        return isDeleted;
    }

    /**
     * isDeleted.
     *
     * @param isDeleted the isDeleted to set
     * @since JDK 1.8
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * source.
     *
     * @return the source
     * @since JDK 1.8
     */
    public Integer getSource() {
        return source;
    }

    /**
     * source.
     *
     * @param source the source to set
     * @since JDK 1.8
     */
    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * repeatExposure.
     *
     * @return the repeatExposure
     * @since JDK 1.8
     */
    public Integer getRepeatExposure() {
        return repeatExposure;
    }

    /**
     * repeatExposure.
     *
     * @param repeatExposure the repeatExposure to set
     * @since JDK 1.8
     */
    public void setRepeatExposure(Integer repeatExposure) {
        this.repeatExposure = repeatExposure;
    }

}
