/**
 * Project Name:tuia-core-api<br>
 * File Name:AppDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月9日下午4:35:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto.rsp.app;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 新媒体策略配置返回 date: 2017年4月14日 下午2:50:24 <br/>
 *
 * @author chencheng
 * @version
 */
public class RspEngineAppFlowStrategyDto implements Serializable {

    private static final long    serialVersionUID = -2818272425782261219L;

    /** The id. */
    protected Long               id;

    /** 生效地域,为null表示不限. */
    private String               validRegions;

    /** 失效开始时间. */
    private Date                 invalidStartTime;

    /** 失效結束时间. */
    private Date                 invalidEndTime;

    /** 福袋开关(0表示关，1表示开). */
    private int                  switchLuckybag;

    /** 策略开关(0表示关，1表示开). */
    private int                  switchStrategy;

    /** 代理开关(0表示关，1表示开). */
    private int                  switchProxy;

    /** 有效周期时段转换List */
    private List<ValidPeriodDto> validPeriodList;

    /** 有效周期时段. */
    private String               validPeriod;

    /** 屏蔽的URL. */
    private String               shieldUrl;

    public static class ValidPeriodDto implements Serializable {

        private static final long serialVersionUID = -7241245025279037804L;

        /** 有效周 */
        private int               week;

        /** 有效开始小时 */
        private String            hourBegin;

        /** 有效结束小时 */
        private String            hourEnd;

        public ValidPeriodDto(int week, String hourBegin, String hourEnd) {
            super();
            this.week = week;
            this.hourBegin = hourBegin;
            this.hourEnd = hourEnd;
        }

        public ValidPeriodDto() {}

        /**
         * week.
         *
         * @return the week
         */
        public int getWeek() {
            return week;
        }

        /**
         * week.
         *
         * @param week the week to set
         */
        public void setWeek(int week) {
            this.week = week;
        }

        /**
         * hourBegin.
         *
         * @return the hourBegin
         */
        public String getHourBegin() {
            return hourBegin;
        }

        /**
         * hourBegin.
         *
         * @param hourBegin the hourBegin to set
         */
        public void setHourBegin(String hourBegin) {
            this.hourBegin = hourBegin;
        }

        /**
         * hourEnd.
         *
         * @return the hourEnd
         */
        public String getHourEnd() {
            return hourEnd;
        }

        /**
         * hourEnd.
         *
         * @param hourEnd the hourEnd to set
         */
        public void setHourEnd(String hourEnd) {
            this.hourEnd = hourEnd;
        }

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }

    }

    /**
     * validPeriodList.
     *
     * @return the validPeriodList
     */
    public List<ValidPeriodDto> getValidPeriodList() {
        if (validPeriodList == null) {
            this.validPeriodList = getValidPeriodDtoList();
        }
        return validPeriodList;
    }

    /**
     * validPeriodList.
     *
     * @param validPeriodList the validPeriodList to set
     */
    public void setValidPeriodList(List<ValidPeriodDto> validPeriodList) {
        this.validPeriodList = validPeriodList;
    }

    /**
     * switchStrategy.
     *
     * @return the switchStrategy
     */
    public int getSwitchStrategy() {
        return switchStrategy;
    }

    /**
     * switchStrategy.
     *
     * @param switchStrategy the switchStrategy to set
     */
    public void setSwitchStrategy(int switchStrategy) {
        this.switchStrategy = switchStrategy;
    }

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * validRegions.
     *
     * @return the validRegions
     */
    public String getValidRegions() {
        return validRegions;
    }

    /**
     * validRegions.
     *
     * @param validRegions the validRegions to set
     */
    public void setValidRegions(String validRegions) {
        this.validRegions = validRegions;
    }

    /**
     * invalidStartTime.
     *
     * @return the invalidStartTime
     */
    public Date getInvalidStartTime() {
        return invalidStartTime;
    }

    /**
     * invalidStartTime.
     *
     * @param invalidStartTime the invalidStartTime to set
     */
    public void setInvalidStartTime(Date invalidStartTime) {
        this.invalidStartTime = invalidStartTime;
    }

    /**
     * invalidEndTime.
     *
     * @return the invalidEndTime
     */
    public Date getInvalidEndTime() {
        return invalidEndTime;
    }

    /**
     * invalidEndTime.
     *
     * @param invalidEndTime the invalidEndTime to set
     */
    public void setInvalidEndTime(Date invalidEndTime) {
        this.invalidEndTime = invalidEndTime;
    }

    /**
     * switchLuckybag.
     *
     * @return the switchLuckybag
     */
    public int getSwitchLuckybag() {
        return switchLuckybag;
    }

    /**
     * switchLuckybag.
     *
     * @param switchLuckybag the switchLuckybag to set
     */
    public void setSwitchLuckybag(int switchLuckybag) {
        this.switchLuckybag = switchLuckybag;
    }

    /**
     * validPeriod.
     *
     * @return the validPeriod
     */
    public String getValidPeriod() {
        return validPeriod;
    }

    /**
     * validPeriod.
     *
     * @param validPeriod the validPeriod to set
     */
    public void setValidPeriod(String validPeriod) {
        this.validPeriod = validPeriod;
    }

    /**
     * shieldUrl.
     *
     * @return the shieldUrl
     */
    public String getShieldUrl() {
        return shieldUrl;
    }

    /**
     * shieldUrl.
     *
     * @param shieldUrl the shieldUrl to set
     */
    public void setShieldUrl(String shieldUrl) {
        this.shieldUrl = shieldUrl;
    }

    /**
     * switchProxy.
     *
     * @return the switchProxy
     */
    public int getSwitchProxy() {
        return switchProxy;
    }

    /**
     * switchProxy.
     *
     * @param switchProxy the switchProxy to set
     */
    public void setSwitchProxy(int switchProxy) {
        this.switchProxy = switchProxy;
    }

    /**
     * 解析
     */
    public List<ValidPeriodDto> getValidPeriodDtoList() {
        List<ValidPeriodDto> list = new ArrayList<>();
        if (StringUtils.isNotBlank(validPeriod)) {
            JSONArray obj = JSON.parseArray(validPeriod);
            for (int i = 0; i < obj.size(); i++) {
                JSONObject job = obj.getJSONObject(i);
                int week = job.getIntValue("week");
                JSONArray temp = JSON.parseArray(job.get("time").toString());
                for (int j = 0; j < temp.size(); j++) {
                    JSONObject t = temp.getJSONObject(j);
                    String hourBegin = t.getString("startHour");
                    String hourEnd = t.getString("endHour");
                    list.add(new ValidPeriodDto(week, hourBegin, hourEnd));
                }
            }
        }
        return list;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
