package cn.com.duiba.tuia.core.api.enums;

/**
 * adx 广告主外部送审场景
 */
public enum AdxAccountAuditStatusEnum {

    PROMOTE_URL_CHANGE(1,"落地页变更"),

    MATERIAL_INSIDE_AUDIT_PASS(2,"素材内部审核通过"),

    ACCOUNT_CERTIFICATE_AUDIT_PASS(3,"广告主资质审核通过"),

    ACCOUNT_REAUDIT(4,"送审失败的广告主再次送审"),

    UNKNOW(-1,"未知");


    /**
     * 场景id
     */
    private Integer status;

    /**
     * 场景描述
     */
    private String desc;

    AdxAccountAuditStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static AdxAccountAuditStatusEnum getAdxAccountAuditStatusEnumByCode(Integer code){

        for(AdxAccountAuditStatusEnum item:AdxAccountAuditStatusEnum.values()){

            if(item.status.equals(code)){
                return item;
            }
        }

        return UNKNOW;
    }
}
