/**
 * Project Name:tuia-advert-center-api File Name:AdvertTradeAcceptLevel.java Package
 * Name:cn.com.duiba.tuia.core.api.enums.advert Date:2018年3月21日上午10:11:24 Copyright (c) 2018, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.core.api.enums.advert;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * ClassName:AdvertTradeAcceptLevel <br/>
 * Function: 广告行业接受度枚举. <br/>
 * Date: 2018年3月21日 上午10:11:24 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
public enum AdvertTradeAcceptLevelEnum {
    /** 接受. */
    ACCEPT(1, "接受"),

    /** 喜欢 */
    LIKE(2, "喜欢"),

    /** 无感 */
    NOSENSE(3, "无感"),

    /** 排斥 */
    REJECT(4, "排斥"),

    /** 其他. */
    OTHER(0, "其他");

    private String  desc;

    private Integer code;

    AdvertTradeAcceptLevelEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer, AdvertTradeAcceptLevelEnum> enumMap = Maps.newHashMap();
    static {
        for (AdvertTradeAcceptLevelEnum it : AdvertTradeAcceptLevelEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static AdvertTradeAcceptLevelEnum getByName(Integer code) {
        return enumMap.get(code);
    }
}
