/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.dto;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;

public class PageDto<T>
implements Serializable {
    private static final long serialVersionUID = -7934666904183628117L;
    private int totalCount;
    private int totalPage;
    private List<T> list;

    public PageDto() {
    }

    public PageDto(int totalAmount, List<T> list, int pageSize) {
        this.totalCount = totalAmount;
        this.list = list;
        this.totalPage = this.setPageCount(pageSize);
    }

    private int setPageCount(int pageSize) {
        if (this.totalCount < 0 || pageSize <= 0) {
            return 0;
        }
        return this.totalCount % pageSize == 0 ? this.totalCount / pageSize : this.totalCount / pageSize + 1;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PageDto [totalCount=");
        builder.append(this.totalCount);
        builder.append(", totalPage=");
        builder.append(this.totalPage);
        builder.append(", list=");
        builder.append(this.list);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }

    public static <T> PageDto<T> emptyPage() {
        PageDto<T> pageDto = new PageDto<T>();
        pageDto.setList(Lists.newArrayList());
        pageDto.setTotalCount(0);
        super.setPageCount(-1);
        return pageDto;
    }
}

