package cn.com.duiba.tuia.core.api.enums;

public enum QualificationCheckEnum {

    PENDING(0, "待审"),

    PASS(1, "通过"),

    REFUSE(2, "拒绝");

    /** 代码 */
    private int code;
    /** 描述 */
    private String desc;

    private QualificationCheckEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static QualificationCheckEnum getByCode(int code){
        for(QualificationCheckEnum enumVal : QualificationCheckEnum.values()){
            if(code == enumVal.getCode()){
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
