package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.abtest.ABTestPlanStatusDTO;

import java.util.List;
import java.util.Map;

/**
 * 实验平台相关Remote接口
 *
 * @author zhangbaiqiang
 * @date 2021/3/3
 */
@AdvancedFeignClient
public interface RemoteABTestService {

    /**
     * 获取落地页测试和素材测试的实验平台计划映射
     *
     * @param advertIds 广告Id列表
     * @return 广告ID-(测试类型-实验计划)映射
     */
    Map<Long, Map<Integer, ABTestPlanStatusDTO>> getABTestPlanMap(List<Long> advertIds);

    /**
     * 获取广告广告扶持实验层的数据
     * @param advertIds
     * @return
     */
    List<ABTestPlanStatusDTO> getABTestPlanByAdvertIdsAndLayer(List<Long> advertIds);

}
