package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertExpandDto;

import java.util.List;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteAdvertExpandService {

    /**
     * 判断是否在白名单中
     * @param isInWhiteList
     * @return
     */
    List<Long> selectByWhiteList(Integer isInWhiteList);

    /**
     * 新增
     */
    Boolean addAdvertWhiteList(Set<Long> advertIds,Integer isInWhiteList);

    /**
     * 更新
     */
    Boolean updateAdvertWhiteList(Set<Long> advertIds,Integer isInWhiteList);

    /**
     * 查询广告的百名单状态
     */
    Boolean selectWhiteListStatusByAdvertId(Long advertId);

    /**
     * [直投创意库]是否隐藏无效创意
     *
     * @param advertId 广告id
     * @return 1.隐藏,0.显示
     */
    Integer isHideInvalidAdvertMaterial(Long advertId);

    /**
     * [直投创意库]更新是否隐藏无效创意
     *
     * @param advertId 广告id
     * @param isHide 是否隐藏:1.隐藏,0.显示
     */
    void updateIsHideInvalidAdvertMaterial(Long advertId, Integer isHide);

    /**
     * @param advertIds
     * @return
     */
    List<AdvertExpandDto> selectByAdvertIds(List<Long> advertIds);

    /**
     * 根据广告ID查询扩展信息
     * @param adverId
     * @return
     */
    AdvertExpandDto selectByAdvertId(Long adverId);

    /**
     * 更新广告扩展表信息
     * @param advertExpandDto
     * @return
     */
    int updateAdvertExpand(AdvertExpandDto advertExpandDto);
}
