/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.core.api.utils;

import java.util.ArrayList;
import java.util.List;

public class TuiaCollectionUtils {
    public static <T> List<List<T>> subListBlock(List<T> list, int blockSize) {
        ArrayList<List<T>> lists = new ArrayList<List<T>>();
        if (list != null && blockSize > 0) {
            int listSize = list.size();
            if (listSize <= blockSize) {
                lists.add(list);
                return lists;
            }
            int batchSize = listSize / blockSize;
            int remain = listSize % blockSize;
            for (int i = 0; i < batchSize; ++i) {
                int fromIndex = i * blockSize;
                int toIndex = fromIndex + blockSize;
                lists.add(list.subList(fromIndex, toIndex));
            }
            if (remain > 0) {
                lists.add(list.subList(listSize - remain, listSize));
            }
        }
        return lists;
    }

    public static int calculateNeedTaskNumber(int size, Integer singleQueryMaxNum) {
        if (size % singleQueryMaxNum == 0) {
            return size / singleQueryMaxNum;
        }
        return size / singleQueryMaxNum + 1;
    }
}

