package cn.com.duiba.tuia.core.api.dto.abtest;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 实验平台请求参数
 *
 * @author zhangbaiqiang
 * @date 2021/2/4
 */
@Data
public class ABTestPlanReq {

    /**
     * 广告ID
     */
    private Long advertId;

    /**
     * 开始时间
     **/
    private Date startTime;

    /**
     * 结束时间
     **/
    private Date endTime;

    /**
     * 分流比例
     **/
    private Integer testRatio;

    /**
     * 实验层编码
     **/
    private String testLayerCode;

    /**
     * 实验层名称
     **/
    private String testLayerName;

    /**
     * 定向配置
     */
    private List<Long> orientIds;

    /**
     * 分流的子项
     */
    private List<ABTestItem> items;

    /**
     * 自增ID
     */
    private Integer autoIncrId;

    /**
     * 操作人
     */
    private Long adminId;

    /**
     * 是否域测试
     */
    private Integer isDomain;
}
