package cn.com.duiba.tuia.core.api.remoteservice.jfsite;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfAccountDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfAccountFormDTO;
import cn.com.duiba.tuia.core.api.dto.jfsite.JfAccountQueryDTO;

import java.util.List;

/**
 * [JF建站]账户表 RemoteService
 * @author lijicong
 * @since 2020-07-24
 */
@AdvancedFeignClient
public interface RemoteJfAccountService {

    /**
     * 根据ID查询
     * @param id
     * @return
     */
    JfAccountDTO queryById(Long id);

    /**
     * 根据email查询
     * @param email
     * @return
     */
    JfAccountDTO queryByEmail(String email);

    /**
     * 多条件查询
     * @param queryDTO
     * @return
     */
    List<JfAccountDTO> queryList(JfAccountQueryDTO queryDTO);

    /**
     * 查询数量
     * @param queryDTO
     * @return
     */
    long queryCount(JfAccountQueryDTO queryDTO);

    /**
     * 多条件查询
     * @param queryDTO
     * @return
     */
    PageDto<JfAccountDTO> queryPage(JfAccountQueryDTO queryDTO);

    /**
     * 保存
     * @param formDTO
     * @return
     */
    boolean save(JfAccountFormDTO formDTO);
}