package cn.com.duiba.tuia.core.api.remoteservice.mobileStatistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.mobileData.QueryMobileAdvertDataByHourDto;
import cn.com.duiba.tuia.core.api.dto.rsp.mobile.MobileAdvertDataByHourDto;

import java.util.List;

/**
 * @author wangting
 * @version 1.0
 * @ClassName: RemoteMobileStaticsService
 * Reason:	 移动·端-数据交互 <br/>
 * Date:     2019/1/29 0029 上午 11:31
 */
@AdvancedFeignClient
public interface RemoteMobileAdvertStaticsService {

    /**
     * 移动端 查询广告每小时数据 数量
     * @param dto
     * @return
     */
    Integer selectDataAmountByHour(QueryMobileAdvertDataByHourDto dto);

    /**
     * 移动端 查询广告每小时数据 (消耗、成本)
     * @param dto
     * @return
     */
    List<MobileAdvertDataByHourDto> selectDataByHour(QueryMobileAdvertDataByHourDto dto);

}
