package cn.com.duiba.tuia.core.api.remoteservice.newMaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialDto;
import cn.com.duiba.tuia.core.api.dto.testMaterial.NewMaterialDto;
import cn.com.duiba.tuia.core.api.dto.testMaterial.NewMaterialFeatureDto;


import java.util.List;
import java.util.Map;

/**
 * @Author:zhangmeng
 * @Date:2018-08-07
 * @Function:素材管理
 */
@AdvancedFeignClient
public interface RemoteMaterialService {

    /**
     * 保存或者更新素材
     * @param newMaterialDto
     * @return
     */
    Long save(NewMaterialDto newMaterialDto);

    /**
     * 获取该行业下的所有素材，分页展示,按照日期倒排
     * @param newTrade
     * @return
     */
    List<NewMaterialDto> getAllMaterialByTrade(String newTrade);

    /**
     *获取广告对应ae，以及广告所属行业下的素材信息（七日内）
     * @param aeId
     * @param advertId
     * @return
     */
    Map<String,List<NewMaterialDto>> getMaterialsByAeOrTrade(Long aeId, Long advertId);

    /**
     * 获取已上传素材图片的所有行业
     * @return
     */
    List<String> getMaterialsTrade();

    /**
     * 获取当日新素材标签
     * @return
     */
    List<String> getAllNewTrad();

    /**
     * 获取所有特征属性
     * @return
     */
    List<NewMaterialFeatureDto> getAllFeaturesValue();

    /**
     * 查看当前广告下是否存在过改新素材属性
     */
    Boolean checkNewMaterial(Long advertId,Long photoId);

    /**
     * 根据活动ID查询绑定的广告ID集合
     * @param activityId
     * @return
     */
    List<Long> listAdvertIdsByActivityId(Long activityId);

    List<AdvertMaterialDto> getAllMaterialsByPhotoIds (List<Long> photoIds);

    /**
     *  初始化 或者 修正 特殊素材的 积木标签
     * @return
     */
    Boolean initMaterialJimuTags();
}
