package cn.com.duiba.tuia.core.api.enums.compensate;

import java.util.Objects;
import java.util.stream.Stream;

/**
 * 赔付状态枚举
 *
 * @author peanut.huang
 * @date 2019/10/15
 * @since JDK 1.8
 */
public enum CompensateStatusEnum {

    /**
     *
     */
    UN_COMPENSATE(0, "未赔付"),

    COMPENSATING(1, "赔付中"),

    COMPENSATED(2, "已赔付")

    ;

    /**
     * 状态值
     */
    private Integer status;

    /**
     * 描述
     */
    private String  desc;

    CompensateStatusEnum(Integer status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据状态值获取枚举
     *
     * @param status 状态值
     * @return
     */
    public static CompensateStatusEnum findByStatus(Integer status){
        if(status == null){
            return null;
        }
        return Stream.of(CompensateStatusEnum.values()).filter(e -> Objects.equals(e.getStatus(), status)).findFirst().orElse(null);
    }
}
