/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertMaterialService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年12月23日下午3:34:25<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialCache;
import cn.com.duiba.tuia.core.api.dto.AdvertMaterialDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMaterialList;
import cn.com.duiba.tuia.core.api.dto.rsp.RspMaterialRefuseInfo;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * ClassName: RemoteAdvertMaterialService <br/>
 * Function: 广告素材开放给前端系统调用的接口定义. <br/>
 * date: 2016年12月23日 下午3:34:25 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertMaterialService {

    /**
     * 素材变成老素材.
     *
     * @param materialId the material id
     * @param appId the app id
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateOldStatus(Long advertId, Long materialId, Long appId);

    /**
     * 获取广告素材新老状态标记值.
     *
     * @param materialId the material id
     * @param appId the app id
     * @return the dubbo result< integer>
     */
    DubboResult<Integer> getNewOldStatus(Long advertId, Long materialId, Long appId);

    /**
     * 获取广告素材列表.
     *
     * @param advertId the advert id
     * @param appId the app id
     * @return the material list
     */
    DubboResult<RspMaterialList> updateMaterialList(Long advertId, Long appId);

    /**
     * 获取广告素材详情.
     *
     * @param materialId the material id
     * @return the material detail
     */
    DubboResult<AdvertMaterialCache> updateMaterialCache(Long materialId);

    Map<Long, String> selectLastRefuseReason(List<Long> materialIds, Integer materialType);

    Map<Long, RspMaterialRefuseInfo> selectLastRefuseInfo(List<Long> materialIds, Integer materialType);

    /**
     * 更新该广告所有素材的 进审时间
     * @param advertId
     * @return
     */
    Integer updateEnterCheckTime(Long advertId);
}
