/**
 * Project Name:tuia-core-api<br>
 * File Name:Tag.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月27日下午7:22:11<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.rsp.tag;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName: NewTagDto <br/>
 * Function: 新标签. <br/>
 * date: 2018年1月15日 上午11:58:34 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class NewTagDto extends BaseDto {

    private static final long  serialVersionUID = 6432966901448331659L;

    /** 0级菜单，最上级. */
    public static final int    LEVEL_OF_ZERO    = 0;

    /** 1级菜单. */
    public static final int    LEVEL_OF_ONE     = 1;

    /** 2级菜单. */
    public static final int    LEVEL_OF_TWO     = 2;

    /** 新标签tag_nun分隔符 */
    public static final String SPLIT_SIGN       = ".";

    /** 删除. */
    public static final int    IS_DELETED       = 1;

    /** 未删除 */
    public static final int    IS_NOT_DELETED   = 0;

    /** 标签名称 */
    private String             tagName;

    /** 标签编号 */
    private String             tagNum;

    /** 上级节点 */
    private Long               parentId;

    /** 标签对应的广告id */
    private Integer            tagLevel;

    /** 是否删除,1-已删除;0-未删除 */
    private Integer            isDeleted;

    /**
     * isDeleted.
     *
     * @return the isDeleted
     * @since JDK 1.8
     */
    public Integer getIsDeleted() {
        return isDeleted;
    }

    /**
     * isDeleted.
     *
     * @param isDeleted the isDeleted to set
     * @since JDK 1.8
     */
    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    /**
     * tagName.
     *
     * @return the tagName
     * @since JDK 1.8
     */
    public String getTagName() {
        return tagName;
    }

    /**
     * tagName.
     *
     * @param tagName the tagName to set
     * @since JDK 1.8
     */
    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    /**
     * tagNum.
     *
     * @return the tagNum
     * @since JDK 1.8
     */
    public String getTagNum() {
        return tagNum;
    }

    /**
     * tagNum.
     *
     * @param tagNum the tagNum to set
     * @since JDK 1.8
     */
    public void setTagNum(String tagNum) {
        this.tagNum = tagNum;
    }

    /**
     * parentId.
     *
     * @return the parentId
     * @since JDK 1.8
     */
    public Long getParentId() {
        return parentId;
    }

    /**
     * parentId.
     *
     * @param parentId the parentId to set
     * @since JDK 1.8
     */
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    /**
     * tagLevel.
     *
     * @return the tagLevel
     * @since JDK 1.8
     */
    public Integer getTagLevel() {
        return tagLevel;
    }

    /**
     * tagLevel.
     *
     * @param tagLevel the tagLevel to set
     * @since JDK 1.8
     */
    public void setTagLevel(Integer tagLevel) {
        this.tagLevel = tagLevel;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
