package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.MediaExploitWhitelistDto;

import java.util.List;

/**
 * 全局配置的智能拓量开关白名单Remote接口
 *
 * @author zhangbaiqiang
 * @date 2021/1/22
 */
@AdvancedFeignClient
public interface RemoteMediaExploitWhitelistService {

    /**
     * 添加白名单
     *
     * @param dto 参数
     * @return 是否添加成功
     * @throws BizException
     */
    boolean add(MediaExploitWhitelistDto dto) throws BizException;

    /**
     * 删除白名单
     *
     * @param advertId 广告Id
     * @return 是否删除成功
     * @throws BizException
     */
    boolean delete(Long advertId) throws BizException;

    /**
     * 查询所有白名单
     *
     * @return 白名单列表
     */
    List<MediaExploitWhitelistDto> query();

    /**
     * 查询配置是否在白名单中
     *
     * @param advertId 广告Id
     * @param pkgId 配置Id
     * @return 配置是否在白名单
     */
    boolean isPkgInWhitelist(Long advertId, Long pkgId);
}
